local colored_lines={}
local lines={{color={1,0,0},direction=1,opacities={},name="Red"},{color={0,1,0},direction=-1,opacities={},name="Green"},{color={1,1,0},direction=1,opacities={},name="Yellow"},{color={1,0,1},direction=-1,opacities={},name="PurplePink"},{color={1,0.647,0},direction=1,opacities={},name="Orange"},{color={0,0.647,1},direction=-1,opacities={},name="LightBlue"},{color={0,0,1},direction=-1,opacities={},name="Blue"}}
local lineCount=32
local screenHeight=1080
local screenWidth=1920
local desiredStackHeight=112
local barSpacing=desiredStackHeight/(lineCount-1)
local barThickness=barSpacing
local cycleSpeedMin=0.04
local cycleSpeedMax=0.15
local function hsvToRgb(h,s,v)
if s<=0 then return v,v,v end
h=(h%1)*6
local i=math.floor(h)
local f=h-i
local p=v*(1-s)
local q=v*(1-s*f)
local t=v*(1-s*(1-f))
if i==0 then return v,t,p
elseif i==1 then return q,v,p
elseif i==2 then return p,v,t
elseif i==3 then return p,q,v
elseif i==4 then return t,p,v
else return v,p,q end
end
math.randomseed(os.time())
function colored_lines.load()
local usedYPositions={}
for _,line in ipairs(lines)do
local y
repeat
y=math.random(10,screenHeight-10)
local tooClose=false
for _,usedY in ipairs(usedYPositions)do
if math.abs(y-usedY)<10 then tooClose=true break end
end
if not tooClose then table.insert(usedYPositions,y) break end
until false
line.y=y
line.speed=math.random(120,512)
line.hue=math.random()
line.hueSpeed=cycleSpeedMin+math.random()*(cycleSpeedMax-cycleSpeedMin)
for i=1,lineCount do
local t=(i-1)/(lineCount-1)
line.opacities[i]=0.5*(1-math.cos(2*math.pi*t))
end end
for i=#lines,2,-1 do
local j=math.random(i)
lines[i],lines[j]=lines[j],lines[i]
end end
function colored_lines.update(dt)
for _,line in ipairs(lines)do
line.y=line.y+(line.direction*line.speed*dt)
if line.y<0 or line.y>screenHeight then line.direction=-line.direction end
line.hue=(line.hue+line.hueSpeed*dt)%1.0
end end
function colored_lines.draw()
for _,line in ipairs(lines)do
local r,g,b=hsvToRgb(line.hue,1.0,1.0)
for i=1,lineCount do
love.graphics.setColor(r,g,b,line.opacities[i])
love.graphics.rectangle("fill",0,line.y-(desiredStackHeight*0.5)+(i-1)*barSpacing,screenWidth,barThickness)
end end end
return colored_lines
